% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departure_best_plot.R
\name{departure_best_plot}
\alias{departure_best_plot}
\title{Plot of deviations from the best performer}
\usage{
departure_best_plot(
  cumulaDifVector,
  mainCountry = NA,
  countries = c(NA, NA),
  displace = 0.25,
  axis_name_y = "Countries",
  val_alpha = 0.95,
  debug = FALSE
)
}
\arguments{
\item{cumulaDifVector}{a vector of cumulated differences, say from
a call to departure_best()$res$cumulated_dif, with named elements.}

\item{mainCountry}{the main country of interest.}

\item{countries}{selection of countries to display; NA means all countries}

\item{displace}{graphical displacement}

\item{axis_name_y}{name of the axis}

\item{val_alpha}{transparency value in (0,1].}

\item{debug}{a flag to get debug information as msg component}
}
\value{
a list with ggplot2 graphical object within res component
}
\description{
Deviations from the best performer  are added over years
and plotted by country.
}
\examples{
\donttest{
# Example 1
# Sorted dataframe in the format years by countries:
require(tibble)
testTB <- dplyr::tribble(
~time, ~countryA ,  ~countryB,  ~countryC,
2000,     0.8,   2.7,    3.9,
2001,     1.2,   3.2,    4.2,
2002,     0.9,   2.9,    0.1,
2003,     1.3,   2.9,    1.0,
2004,     1.2,   3.1,    4.1,
2005,     1.2,   3.0,    4.0
)

# Departures from the best country according to the "highBest" indicator:
mySTB <- departure_best(testTB,timeName="time",indiType = "highBest")

# Plot of deviations from the best performer:
departure_best_plot(cumulaDifVector = mySTB$res$cumulated_dif, mainCountry = "countryC",
countries = c("countryA","countryB"),displace = 0.25,
axis_name_y = "Countries",val_alpha  = 0.95,debug=FALSE)

# Departures from the best country according to the "lowBest" indicator:
mySTB1 <- departure_best(testTB,timeName="time",indiType = "lowBest")
departure_best_plot(cumulaDifVector = mySTB1$res$cumulated_dif, mainCountry = "countryC",
countries = c("countryA","countryB"),displace = 0.25,
axis_name_y = "Countries",val_alpha  = 0.95,debug=FALSE)

# Example 2
# Departures from the best country for the emp_20_64_MS Eurofound dataset:
mySTB2 <- departure_best(emp_20_64_MS,timeName="time",indiType = "highBest")
# Plot of deviations from the best performer with Italy as the country of interest:
departure_best_plot(mySTB2$res$cumulated_dif,
  mainCountry = "IT",
  countries=c("AT", "DE", "FR","SE","SK"),
  displace = 0.25,
  axis_name_y = "Countries",
  val_alpha  = 0.95,
  debug=FALSE)

 mySTB3 <- departure_best(emp_20_64_MS,timeName="time",indiType = "lowBest")
 # Plot of deviations from the best performer with Germany as the country of interest:
 departure_best_plot(mySTB3$res$cumulated_dif,
 mainCountry = "DE",
 countries=c("AT", "SE", "FR","IT","SK"),
 displace = 0.25,
 axis_name_y = "Countries",
 val_alpha  = 0.95,
 debug=FALSE)
 }
}
\references{
{\url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
