% Generated by roxygen2 (4.0.2): do not edit by hand
\name{TaylorContour}
\alias{TaylorContour}
\title{Computes tail probabilities of a Gaussian field on a contour with Taylor's
method.}
\usage{
TaylorContour(x, y, f, level, R)
}
\arguments{
\item{x}{x-Coordinates of the grid on which the data is observed.}

\item{y}{y-Coordinates of the grid on which the data is observed.}

\item{f}{A matrix of dimension c(length(x),length(y)). The contour on which
tail probabilities are to be computed is defind as {f=c}.}

\item{level}{The level of the contour.}

\item{R}{An array of dimension c(length(x),length(y),n) containing the
realizations of the field.}
}
\value{
A function g that computes for u>0 the probility that the supremum of
        the field exceeds u.
}
\description{
Computes tail probabilities of a Gaussian field on a contour with Taylor's
method.
}

