% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cops.R
\name{pcops}
\alias{pcops}
\title{Profile COPS Function (aka COPS Variant 2)}
\usage{
pcops(dis, loss = c("stress", "smacofSym", "smacofSphere", "strain",
  "sammon", "rstress", "powermds", "sstress", "elastic", "powersammon",
  "powerelastic", "powerstress", "sammon2", "powerstrain", "apstress"),
  weightmat = NULL, ndim = 2, init = NULL, theta = c(1, 1, 1),
  stressweight = 1, cordweight, q = 2, minpts = ndim + 1,
  epsilon = 100, rang, optimmethod = c("ALJ", "pso", "SANN", "DIRECT",
  "DIRECTL", "stogo", "MADS", "hjk"), lower = c(1, 1, 0.5),
  upper = c(5, 5, 2), verbose = 0, scale = c("proc", "sd", "none",
  "std"), normed = TRUE, s = 4, stresstype = "default",
  acc = 1e-07, itmaxo = 200, itmaxi = 10000, ...)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{loss}{which loss function to be used for fitting, defaults to strain. Currently allows for the following models:
\itemize{
\item Power transformations of observed proximities only: Strain loss or classical scaling (\code{strain}, workhorse is cmdscale), Kruskall's stress for symmetric matrices (\code{smacofSym} or \code{stress} and \code{smacofSphere} for scaling onto a sphere; workhorse is smacof), Sammon mapping (\code{sammon} or \code{sammon2}; for the earlier the workhorse is sammon from MASS for the latter it is smacof), elastic scaling (\code{elastic}, the workhorse is smacof), Takane et al's S-Stress \code{sstress} (workhorse is powerstressMin)
\item Power transformations of fitted distances only: De Leeuw's r-stress \code{rstress} (workhorse is powerstressMin)
\item Power transformations of fitted distances and observed proximities: Powermds \code{powermds}, Sammon mapping and elastic scaling with powers (\code{powersammon}, \code{powerelastic}, \code{powerstress}; workhorse is powerstressMin)
\item Approximation to power stress: Approximated power stress (\code{apstress}; workhorse is smacof)
}}

\item{weightmat}{(optional) a matrix of nonnegative weights; defaults to 1 for all off diagonals}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration. If not supplied, the Torgerson scaling result of the dissimilarity matrix dis^theta[2]/enorm(dis^theta[2],weightmat) is used.}

\item{theta}{the theta vector of powers; the first is kappa (for the fitted distances if it exists), the second lambda (for the observed proximities if it exist), the third is nu (for the weights if it exists) . If a scalar is given as argument, it will take the role designated by the loss argument. Defaults to 1 1 1}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{cordweight}{weight to be used for the cordillera; if missing gets estimated from the initial configuration so that copstress = 0 for theta=c(1,1)}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to ndim+1}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{rang}{range of the minimum reachabilities to be considered. If missing it is found from the initial configuration by taking 1.5 times the maximal minimum reachability of the model with theta=c(1,1). If NULL it will be normed to each configuration's minimum and maximum distance, so an absolute value of goodness-of-clusteredness. Note that the latter is not necessarily desirable when comparing configurations for their relative clusteredness. See also \code{\link{cordillera}}}

\item{optimmethod}{What general purpose optimizer to use? Defaults to our adaptive LJ version (ALJ). Also allows particle swarm optimization with s particles ("pso") and simulated annealing ("SANN"), "DIRECT" and "DIRECTL", Hooke-Jeeves ("hjk"), StoGo ("stogo"), and "MADS". We recommend not using SANN and pso with the rstress, sstress and the power stress models. We amde good experiences with ALJ, stogo, DIRECT and DIRECTL and also MADS.}

\item{lower}{The lower contraints of the search region}

\item{upper}{The upper contraints of the search region}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{scale}{should the configuration be scaled and/or centered for calculating the cordillera? "std" standardizes each column of the configurations to mean=0 and sd=1, "sd" scales the configuration by the maximum standard devation of any column, "proc" adjusts the fitted configuration to the init configuration (or the Togerson scaling solution if init=NULL). This parameter only has an effect for calculating the cordillera, the fitted and returned configuration is NOT scaled.}

\item{normed}{should the cordillera be normed; defaults to TRUE}

\item{s}{number of particles if pso is used}

\item{stresstype}{what stress to be used for comparisons between solutions. Currently not implemented and pcops uses explicitly normalized stress for copstress (not stress-1). Stress-1 is reported by the print function though.}

\item{acc}{termination threshold difference of two successive outer minimization steps.}

\item{itmaxo}{iterations of the outer step (optimization over the hyperparmeters; if solver allows it). Defaults to 200.}

\item{itmaxi}{iterations of the inner step (optimization of the MDS). Defaults to 10000 (whichis huge).}

\item{...}{additional arguments to be passed to the optimization procedure}
}
\value{
A list with the components
        \itemize{
        \item copstress: the weighted loss value
        \item OC: the Optics cordillera
        \item optim: the object returned from the optimization procedure
        \item stress: the stress (square root of stress.m)
        \item stress.m: default normalized stress 
        \item parameters: the parameters used for fitting (kappa, lambda)
        \item fit: the returned object of the fitting procedure
        \item cordillera: the cordillera object
}
}
\description{
Metaparameter selection for MDS models baseed on the Profile COPS approach (COPS Variant 2). It uses copstress for hyperparameter selection. It is a special case of a STOPS model.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)
set.seed(210485)
#configuration is scaled with highest column sd for calculating cordilera 
res1<-pcops(dis,loss="strain",lower=0.1,upper=5,minpts=2) 
res1
summary(res1)
plot(res1)


}
\keyword{clustering}
\keyword{multivariate}
