% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optics.R
\name{e_optics}
\alias{e_optics}
\title{OPTICS in ELKI}
\usage{
e_optics(x, minpts = 2, epsilon, path = tempdir(), keep = FALSE)
}
\arguments{
\item{x}{numeric matrix or data frame}

\item{minpts}{the minpts argument to \code{elki}. Defaults to 2.}

\item{epsilon}{The epsilon parameter for OPTICS. Defaults to 2 times the range of x.}

\item{path}{the path for storing the temporary files I/O files. Defaults to tempdir().}

\item{keep}{should the optics results from \code{elki} be stored in path. If TRUE, it will make a directory ./opticsout and a file config.txt}
}
\value{
a list with the contents of the \code{elki} output file as a data frame as element
\itemize{
 \item $clusterobjectorder, which is the clusterobjectorder file from \code{elki}. The first column is the OPTICS ordering (so the ID of the points in successive order), followed by the data in x, the next column lists the reachability followed by the predecessor of each point x[i,] in the ordering in the last column  
 \item $eps
 \item $minpts
}
}
\description{
A rudimentary I/O interface to OPTICS in 'ELKI' reroutes input from R to elki via the command line, runs elki.optics on an Input file (config.txt), sets up a temporary directory opticsout in path, reads in the contents of the \code{elki} output file clusterobjectorder.txt and deletes I/O files and directories. Returns the contents or clusterobjectorder.txt as a data frame.
needs ELKI > 0.6.0 - Only tested with the Ubuntu trusty binaries very rudimentary as of yet. API of ELKI is not fixed. No plans for using this in the future.
}
\examples{
\donttest{
data(iris)
res<-e_optics(iris[,1:4],minpts=2,epsilon=100)
print(res)
summary(res)
plot(res,withlabels=TRUE)
}


}
\keyword{clustering}
\keyword{multivariate}
