% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrRect.hclust.R
\name{corrRect.hclust}
\alias{corrRect.hclust}
\title{Draw rectangles on the correlation matrix graph.}
\usage{
corrRect.hclust(
  corr,
  k = 2,
  col = "black",
  lwd = 2,
  method = c("complete", "ward", "ward.D", "ward.D2", "single", "average", "mcquitty",
    "median", "centroid")
)
}
\arguments{
\item{corr}{Correlation matrix for function \code{corrRect.hclust}. It use
\code{1-corr} as dist in  hierarchical clustering (\code{\link{hclust}}).}

\item{k}{Integer, the number of rectangles drawn on the graph according to
the hierarchical cluster, for function \code{corrRect.hclust}.}

\item{col}{Color of rectangles.}

\item{lwd}{Line width of rectangles.}

\item{method}{Character, the agglomeration method to be used for hierarchical
clustering (\code{\link{hclust}}). This should be (an unambiguous
abbreviation of) one of \code{"ward"}, \code{"ward.D"}, \code{"ward.D2"},
\code{"single"}, \code{"complete"}, \code{"average"}, \code{"mcquitty"},
\code{"median"} or \code{"centroid"}.}
}
\description{
Draw rectangles on the correlation matrix graph based on hierarchical cluster
(\code{\link{hclust}}).
}
\examples{
data(mtcars)
M <- cor(mtcars)
corrplot(M, method = "circle", order = "FPC")
corrRect(c(5,6))

(order.hc <- corrMatOrder(M, order = "hclust"))
(order.hc2 <- corrMatOrder(M, order = "hclust", hclust.method = "ward.D2"))
M.hc  <- M[order.hc, order.hc]
M.hc2 <- M[order.hc2, order.hc2]

par(ask = TRUE)

# same as: corrplot(M, order = "hclust", addrect = 2)
corrplot(M.hc)
corrRect.hclust(corr = M.hc, k = 2)

# same as: corrplot(M, order = "hclust", addrect = 3)
corrplot(M.hc)
corrRect.hclust(corr = M.hc, k = 3)

# same as: corrplot(M, order = "hclust", hclust.method = "ward.D2", addrect = 2)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 2, method = "ward.D2")

# same as: corrplot(M, order = "hclust", hclust.method = "ward.D2", addrect = 3)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 3, method = "ward.D2")

# same as: corrplot(M, order = "hclust", hclust.method = "ward.D2", addrect = 4)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 4, method = "ward.D2")
}
\author{
Taiyun Wei
}
\keyword{hplot}
