% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{network_plot}
\alias{network_plot}
\title{Network plot of a correlation data frame}
\usage{
network_plot(x, min_cor)
}
\arguments{
\item{x}{cor_df. See \code{\link{correlate}}.}

\item{min_cor}{Number from 0 to 1 indicating the minimum value of
correlations (in absolute terms) to plot.}
}
\description{
Output a network plot of a correlation data frame in which variables that are
more highly correlated appear closer together and are joined by stronger
paths. Paths are also coloured by their sign (blue for positive and red for
negative). The proximity of the points are determined using multidimensional
clustering.
}
\examples{
x <- correlate(mtcars)
network_plot(x)
network_plot(x, min_cor = .1)
network_plot(x, min_cor = .6)
}

