% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wovr.R
\name{predict.wovr}
\alias{predict.wovr}
\title{Predict method for Weighted One-Vs-Rest}
\usage{
\method{predict}{wovr}(object, newdata, type = "class", ...)
}
\arguments{
\item{object}{An object of class `wovr` as output by function `weighted.one.vs.rest`.}

\item{newdata}{New data on which to make predictions.}

\item{type}{One of "class" (will output the class with minimum expected cost) or "score"
(will output the predicted score for each class, i.e. more is better).}

\item{...}{Additional arguments to pass to the predict method of the base classifier.}
}
\value{
When passing `type = "class"`, a vector with class numbers or names (if the cost matrix had them).
When passing `type = "score"`, will output a `data.frame` with the same number of columns as `C` (passed to
the `weighted.one.vs.rest` function) and the predicted score for each observation and class.
}
\description{
Predicts either the class with expected minimum cost or scores (more is better) for new data.
}
