% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_counts.R
\name{fit_counts}
\alias{fit_counts}
\title{Function that fits counts to distribution models.}
\usage{
fit_counts(counts_list, separate = TRUE, model, level = 0.95, ...)
}
\arguments{
\item{counts_list}{A \code{list} of count data. Each count should be in 
separate column, rows should represent
values of that counts.}

\item{separate}{\code{logical}. If \code{TRUE}, each count is separately 
fitted to the model. If \code{FALSE}, all counts are fitted to the same models 
having the count name as the independent variable.}

\item{model}{single \code{character}: \code{"pois"}, \code{"nb"},
\code{"zinb"}, \code{"zip"}, \code{"all"}. If \code{"all"}, all possible model 
are fitted.}

\item{level}{Confidence level, default is 0.95.}

\item{...}{Dots parameters are ignored.}
}
\value{
The list of fitted models. Names are names of original counts, an underline
and a name of model used.
confint is a \code{matrix} with the number of rows equal to the number of
parameters. Rownames are names of parameters. The columns contain respectively
lower and upper confidence intervals.
}
\description{
Function that fits counts to distribution models.
}
\examples{
df <- data.frame(poisson = rpois(25, 0.3), binomial = rbinom(25, 1, 0.8))
fit_counts(df, model = "pois") 
}
