% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_data.R
\name{county_aggregates2}
\alias{county_aggregates2}
\title{Get county level output from \code{long_range_flood} analysis}
\usage{
county_aggregates2(flood_stats, county_cd)
}
\arguments{
\item{flood_stats}{Data frame of gage-level output from \code{flood_analysis}
function.}

\item{county_cd}{Character vector with the county FIPS code(s)}
}
\value{
A data frame with the following columns:
  \tabular{lll}{
  Name \tab Type \tab Description\cr
  county_cd \tab character \tab FIPS code of gage county location\cr
  start_date \tab date \tab Input start date\cr
  end_date \tab date \tab Input end date\cr
  county \tab character \tab County name\cr
  state \tab character \tab State name\cr
  num_gage \tab numeric \tab Number of analyzed gages in county\cr
  max_peak \tab numeric \tab Maximum observed flood ratio\cr
  avg_peak \tab numeric \tab Average flood ratio among county gages\cr
  minor \tab numeric \tab Percentage of gages at or above "minor" flood
     class (flood ratio > 1)\cr
  moderate \tab numeric \tab Percentage of gages at or above "moderate"
     flood class (flood ratio > 1.5)\cr
  major \tab numeric \tab Percentage of gages at or above "major" flood
     class (flood ratio > 2)\cr
  extreme \tab numeric \tab Percentage of gages at or above "extreme"
     flood class (flood ratio > 5)\cr
  max_dur \tab numeric \tab Maximum flood duration in county\cr
  avg_dur \tab numeric \tab Average flood duration in county }

If threshold = "NWS", the columns "minor", "moderate", "major", and "extreme"
are replaced with two columns: "no_flood" and "yes_flood" which show the
percentage of gages in the county with or without flooding.


Internal function used within \code{long_term_flood} function.
}
\description{
Function aggregates gage-level output into county-level output. This is
the same as the \code{county_aggregates} function but it summarizes by
county and date range instead of just county.
}
