% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_demo}
\alias{covid19sf_demo}
\title{San Francisco COVID-19 Cases Summarized by Date, Transmission and Case Disposition}
\format{
An object class data.frame with 5 variables
\describe{
  \item{specimen_collection_date}{Date which case was recorded in YYYY-MM-DD format.}
  \item{race_ethnicity}{The cases race/ethnicity}
  \item{new_confirmed_cases}{Daily new confirmed cases}
  \item{cumulative_confirmed_cases}{Cumulative confirmed cases}
  \item{last_updated}{The table last update time in POSIX format}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_demo
}
\description{
This dataset represents the COVID-19 positive confirmed cases by
race and ethnicity. Demographic data are based on information
reported from case interviews, laboratories, and providers.
This data may not be immediately available for recently reported cases and data will
change to reflect as information becomes available.
Cumulative counts of 5 or fewer are excluded from the dataset.
More information about the data available \href{https://data.sfgov.org/COVID-19/COVID-19-Cases-Summarized-by-Race-and-Ethnicity/vqqm-nsqg}{here}
}
\details{
The dataset contains the daily summary of covid19 cases in San Francisco by race/ethnicity group
}
\examples{
data(covid19sf_demo)

head(covid19sf_demo)

}
\keyword{COVID19}
\keyword{datasets}
\keyword{demographic}
\keyword{ethnicity}
\keyword{race}
\keyword{summary}
