% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ppl.R
\name{fit_ppl}
\alias{fit_ppl}
\title{Estimate HRs using PPL given a known variance component (tau)}
\usage{
fit_ppl(X, outcome, corr, tau = 0.5, FID = NULL, eps = 1e-06,
  order = 1, eigen = TRUE, dense = FALSE, solver = 1, spd = TRUE,
  verbose = TRUE, invchol = TRUE)
}
\arguments{
\item{X}{A matrix of the preidctors. Can be quantitative or binary values. Categorical variables need to be converted to dummy variables. Each row is a sample, and the predictors are columns.}

\item{outcome}{A matrix contains time (first column) and status (second column). The status is a binary variable (1 for failure / 0 for censored).}

\item{corr}{A relatedness matrix. Can be a matrix or a 'dgCMatrix' class in the Matrix package. Must be symmetric positive definite or symmetric positive semidefinite.}

\item{tau}{A positive scalar. A variance component given by the user. Default is 0.5.}

\item{FID}{An optional string vector of family ID. If provided, the data will be reordered according to the family ID.}

\item{eps}{An optional positive value indicating the tolerance in the optimization algorithm. Default is 1e-6.}

\item{order}{An optional integer value starting from 0. Only valid when dense=FALSE. It specifies the order of approximation used in the inexact newton method. Default is 1.}

\item{eigen}{An optional logical value Only effective when \code{dense=FALSE}. It indicates whether to use RcppEigen:LDLT to solve linear systems. Default is TRUE.}

\item{dense}{An optional logical value indicating whether the relatedness matrix is dense. Default is FALSE.}

\item{solver}{An optional bianry value taking either 1 or 2. Default is 1. See details.}

\item{spd}{An optional logical value indicating whether the relatedness matrix is symmetric positive definite. Default is TRUE.}

\item{verbose}{An optional logical value indicating whether to print additional messages. Default is TRUE.}

\item{invchol}{An optional logical value. Only effective when \code{dense=FALSE}. If TRUE, sparse Cholesky decomposition is used to compute the inverse of the relatedness matrix. Otherwise, sparse LU is used.}
}
\value{
beta: The estimated coefficient for each predictor in X.

HR: The estimated HR for each predictor in X.

sd_beta: The estimated standard error of beta.

iter: The number of iterations until convergence.

ppl: The PPL when the convergence is reached.
}
\description{
\code{fit_ppl} returns estimates of HRs and their p-values given a known variance component (tau).
}
\section{About \code{solver}}{

When solver=1/solver=2, Cholesky decompositon/PCG is used to solve the linear system. However, when \code{dense=FALSE} and \code{eigen=FALSE}, the solve function in the Matrix package is used regardless of \code{solver}.
}

\section{About \code{invchol}}{

Cholesky decomposition using \code{invchol=TRUE} is generally (but not always) much faster to invert a relatedness matrix (e.g., a block-diagonal matrix). But for some types of sparse matrices (e.g., a banded AR(1) matrix with rho=0.9), it sometimes can be very slow. In such cases, \code{invchol=FALSE} is can be used.
}

\examples{
library(Matrix)
library(MASS)
library(coxmeg)

## simulate a block-diagonal relatedness matrix
tau_var <- 0.2
n_f <- 100
mat_list <- list()
size <- rep(10,n_f)
offd <- 0.5
for(i in 1:n_f)
{
  mat_list[[i]] <- matrix(offd,size[i],size[i])
  diag(mat_list[[i]]) <- 1
}
sigma <- as.matrix(bdiag(mat_list))
n <- nrow(sigma)

## simulate random effexts and outcomes
x <- mvrnorm(1, rep(0,n), tau_var*sigma)
myrates <- exp(x-1)
y <- rexp(n, rate = myrates)
cen <- rexp(n, rate = 0.02 )
ycen <- pmin(y, cen)
outcome <- cbind(ycen,as.numeric(y <= cen))

## fit the ppl
re = fit_ppl(x,outcome,sigma,tau=0.5,order=1,eigen=TRUE,dense=FALSE)
re
}
\keyword{Cox}
\keyword{mixed-effects}
\keyword{model}
