\name{cplm-package}
\alias{cplm-package}
\alias{cplm}
\docType{package}
\title{
  Tweedie compound Poisson linear models 
}
\description{This R package provides methods for fitting Tweedie compound Poisson linear models using the Monte Carlo EM algorithm and Markov Chain Monte Carlo methods. The forms of the models that are handled in the package are generalized linear models, mixed-effect models and their corresponding Bayesian models. For non-Bayesian models, maximum likelihood estimations are obtained for all parameters in the model, especially for the index parameter. Estimation for the Bayesian model is performed by Markov Chain Monte Carlo simulations.
   
  More information is available
  on the project web site \url{http://code.google.com/p/cplm/}
}
 
\details{
\tabular{ll}{
Package: \tab cplm\cr
Type: \tab Package\cr
Version: \tab 0.1-2\cr
Date: \tab 2011-09-09\cr
License: \tab GPL version 2 or later\cr
}
}
\author{
Wayne Zhang <actuary_zhang@hotmail.com>
}
\references{
\cite{ Dunn, P.K. and Smyth, G.K. (2005). Series evaluation of Tweedie exponential dispersion models densities. \emph{Statistics and Computing}, 15, 267-280.}

\cite{McCulloch, C. E. (1997). Maximum likelihood algorithms for generalized linear mixed
models. \emph{Journal of the American Statistical Association}, 92, 162-170.}

\cite{Zhang Y. (2011). A Latent Variable Approach for Statistical Inference  in Tweedie Compound Poisson Linear Models, \emph{preprint}, \url{http://actuaryzhang.com/publication/bayesianTweedie.pdf}}

}


\keyword{ package }


