% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{scalefactor}
\alias{scalefactor}
\title{Scaling Factor}
\usage{
scalefactor(x, radius = 0, total.area = 1, area.prop = TRUE)
}
\arguments{
\item{x}{a numeric vector storing the heights of a density curve or
a histogram.}

\item{radius}{the radius of the reference circle.}

\item{total.area}{a positive number specifying the total area.}

\item{area.prop}{logical; if \code{TRUE}, an area-proportional
transformation is applied; if \code{FALSE}, a height-proportional
transformationis applied.}
}
\description{
The function calculates the scaling factor so that after scaling 
  the original density curve (before transformation), the total area after 
  transformation (excluding the reference circle) has the specified value.
}
\details{
Each value in x is a density value before transformation, for points
  equally-spaced on \eqn{[0,2\pi)}. For a smooth density curve, use a 
  reasonably large number of points, equally-spaced on \eqn{[0,2\pi)}. 
  The area under the density curve after transformation is then approximated 
  by that of the corresponding sectors. Note if \code{area.prop = TRUE}, 
  the scale factor is simply the value of \code{total.area}.
}
\examples{
dvm = function(x, mu=0, kappa=1)   # von Mises density
exp(kappa * cos(x - mu)) * (2 * pi * besselI(kappa, 0))^(-1)
x = dvm(seq(0, 2 * pi, len = 100), pi, 10)

scalefactor(x)                            # area-proportional transformation
scalefactor(x, area.prop = FALSE)         # height-proportional transformation
scalefactor(x, total.area = 2)            # total area of 2
scalefactor(x, area.prop = FALSE, total.area = 2)

}
\references{
Xu, D. and Wang, Y. (2019) Area-proportional Visualization for 
Circular Data (submitted).
}
\seealso{
\code{\link{circtrans}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{scale}
