% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_network.R
\name{plot.cranly_network}
\alias{plot.cranly_network}
\title{Interactive visualization of a package or author \code{\link{cranly_network}} using the vis.js library}
\usage{
\method{plot}{cranly_network}(x, package = NULL, author = NULL,
  physics_threshold = 200, height = NULL, width = NULL,
  directive = c("imports", "suggests", "enhances", "depends"),
  dragNodes = TRUE, dragView = TRUE, zoomView = TRUE, exact = TRUE,
  legend = FALSE, title = FALSE, global = TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{cranly_network}} object}

\item{package}{a vector of character strings with the package names to be matched}

\item{author}{a vector of character strings with the author names to be matched}

\item{physics_threshold}{integer. How many nodes before switching off physics simulations for edges? Default is \code{200}. See, also \code{\link[visNetwork]{visEdges}}}

\item{height}{: Height (optional, defaults to automatic sizing)}

\item{width}{: Width (optional, defaults to automatic sizing)}

\item{directive}{a vector of at least one of \code{"Imports"}, \code{"Suggests"}, \code{"Enhances"}, \code{"Depends"}}

\item{dragNodes}{logical. Should the user be able to drag the nodes that are not fixed? Default is \code{TRUE}}

\item{dragView}{logical. Should the user be able to drag the view around? Default is \code{TRUE}}

\item{zoomView}{logical. Should the user be able to zoom in? Default is \code{TRUE}}

\item{exact}{logical. Should we use exact matching? Default is \code{TRUE}}

\item{legend}{logical. Should a legend be added on the resulting visualization? Default is \code{FALSE}}

\item{title}{logical. Should a title be added on the resulting visualization? Default is \code{FALSE}}

\item{global}{locical. If \code{TRUE} (default) the network summary statistics are computed on \code{object}, otherwise, on the subset of \code{object} according to \code{package} and \code{author}}

\item{...}{currently not used}
}
\description{
Interactive visualization of a package or author \code{\link{cranly_network}} using the vis.js library
}
\examples{
\dontrun{
data("cran20032018", package = "cranly")
package_network <- build_network(cran20032018)
## The package directives network of all users with Ioannis in
## their name from the CRAN database subset cran20032018
plot(package_network, author = "Ioannis")
## The package directives network of "Achim Zeileis"
plot(package_network, author = "Achim Zeileis")

author_network <- build_network(cran20032018, perspective = "author")
plot(author_network, author = "Ioannis", title = TRUE)
}
}
