% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crc32c.R
\name{crc32c}
\alias{crc32c}
\title{Cyclic Redundancy Check with Hardware Support}
\usage{
crc32c(x)
}
\arguments{
\item{x}{A character vector}
}
\value{
A character vector of the same length as the incoming vector, with a
\code{crc43c} checksum in hexadecimal as a character value of length eight in each
element.
}
\description{
The \code{crc32c} implementation with hardware support via SSE2 instructions
on \sQuote{x86_64} platforms as well as on \sQuote{arm64} is provided by using
the code from the repository at \url{https://github.com/google/crc32c}.
}
\examples{
crc32c("abc")
}
\references{
https://datatracker.ietf.org/doc/html/rfc3720, doi:10.1109/26.231911
}
\seealso{
https://github.com/google/crc32c
}
