% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{rf_params}
\alias{rf_params}
\title{Random Forest Parameters}
\usage{
rf_params(ntree = 100, nodesize = 30, samp_rate = 0.5,
  tune_rf = FALSE, ...)
}
\arguments{
\item{ntree}{Number of trees to grow. This should not be set to too small a number, to ensure that every input row gets predicted at least a few times.}

\item{nodesize}{Minimum size of terminal nodes. Setting this number larger causes smaller trees to be grown (and thus take less time). Note that the default values are different for classification (1) and regression (5).}

\item{samp_rate}{Percentage of sample to draw. Default is 0.2.}

\item{tune_rf}{A logical.If TRUE, then tune Random Forest model.Default is FALSE.}

\item{...}{Other parameters}
}
\value{
A list of parameters.
}
\description{
\code{rf_params} is the list of parameters to train a Random Forest using in  \code{\link{training_model}}.
}
\details{
See details at : \url{https://www.stat.berkeley.edu/~breiman/Using_random_forests_V3.1.pdf}
}
\seealso{
\code{\link{training_model}}, \code{\link{lr_params}}, \code{\link{gbm_params}}, \code{\link{xgb_params}}
}
