% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{char_to_num}
\alias{char_to_num}
\title{character to number}
\usage{
char_to_num(dat, note = TRUE,
  ex_cols = "date$|id$|time$|DATA$|ID$|TIME$")
}
\arguments{
\item{dat}{A data frame}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}
}
\value{
A data.frame
}
\description{
\code{char_to_num} is  for transfering character variables which are actually numerical numbers containing strings  to numeric.
}
\examples{
dat_sub = lendingclub[c("mths_since_recent_revol_delinq", "mths_since_last_record")]
str(dat_sub)
#variables that are converted to numbers containing strings
dat_sub[is.na(dat_sub)] = "Missing"
str(dat_sub)
dat_sub = char_to_num(dat_sub)
str(dat_sub)
}
