% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{getROC}
\alias{getROC}
\title{Cacluate ROC like metrics.}
\usage{
getROC(f, y)
}
\arguments{
\item{f}{predicted score for linkage}

\item{y}{truth; linked=1, unlinked=0}
}
\value{
data.frame of evaluation metrics:
 \itemize{
     \item FPR - false positive rate - proportion of unlinked pairs that are
       incorrectly assessed as linked
     \item TPR - true positive rate; recall; hit rate - proportion of all linked
       pairs that are correctly assessed as linked
     \item PPV - positive predictive value; precision - proportion of all pairs
       that are predicted linked and truely are linked
     \item Total - the number of cases predicted to be linked
     \item TotalRate - the proportion of cases predicted to be linked
     \item threshold - the score threshold that produces the results
 }
}
\description{
Orders scores from largest to smallest and evaluates performance for each
   value. This assumes an analyst will order the predicted scores and start
   investigating the linkage claim in this order.
}
\examples{
f = 1:10
y = rep(0:1,length=10)
getROC(f,y)
}

