% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{makeGroups}
\alias{makeGroups}
\title{Generates crime groups from crime series data}
\usage{
makeGroups(X, method = 1)
}
\arguments{
\item{X}{crime series data (generated from \code{\link{makeSeriesData}})
  with offender ID (\code{offenderID}),
  crime ID (\code{crimeID}), and the event datetime (\code{TIME})}

\item{method}{Method=1 (default) forms groups by finding
  the maximal connected offender subgraph. Method=2 forms groups from the
  unique group of co-offenders. Method=3 forms from groups from offenderIDs}
}
\value{
vector of crime group labels
}
\description{
This function generates crime groups that are useful for making unlinked pairs
 and for agglomerative linkage.
}
\details{
Method=1 forms groups by finding the maximal connected offender
   subgraph. So if two offenders have ever co-offended, then all of their crimes
   are assigned to the same group. Method=2 forms groups from the unique group
   of co-offenders. So for two offenders who co-offended, all the co-offending
   crimes are in one group and any crimes committed individually or with other
   offenders are assigned to another group. Method=3 forms groups from the
   offender(s) responsible. So a crime that is committed by multiple people
   will be assigned to multiple groups.
}
\examples{
data(crimes)
 data(offenders)
 seriesData = makeSeriesData(crimedata=crimes,offenderTable=offenders)
 groups = makeGroups(seriesData,method=1)
 head(groups,10)
}

