% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{Tabulate}
\alias{Tabulate}
\title{Tabulate Function}
\usage{
Tabulate(code = "mcnp", ext.dir)
}
\arguments{
\item{code}{Monte Carlo radiation transport code (e.g., "cog", "mcnp")}

\item{ext.dir}{External directory (full path)}
}
\value{
A list of centered, scaled, and one-hot-encoded training and test data
}
\description{
This function imports the Scale function and loads/saves training and test data.
}
\examples{

ext.dir <- paste0(tempdir(), "/criticality/extdata")
dir.create(ext.dir, recursive = TRUE, showWarnings = FALSE)

extdata <- paste0(.libPaths()[1], "/criticality/extdata")
file.copy(paste0(extdata, "/facility.csv"), ext.dir, recursive = TRUE)
file.copy(paste0(extdata, "/mcnp-dataset.RData"), ext.dir, recursive = TRUE)

Tabulate(
  code = "mcnp",
  ext.dir = ext.dir
)

}
