% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticLogNormal-class}
\alias{LogisticLogNormal-class}
\alias{.LogisticLogNormal}
\title{Standard logistic model with bivariate (log) normal prior}
\description{
This is the usual logistic regression model with a bivariate normal prior on
the intercept and log slope.
}
\details{
The covariate is the natural logarithm of the dose \eqn{x} divided by
the reference dose \eqn{x^{*}}:

\deqn{logit[p(x)] = \alpha + \beta \cdot \log(x/x^{*})}
where \eqn{p(x)} is the probability of observing a DLT for a given dose
\eqn{x}.

The prior is
\deqn{(\alpha, \log(\beta)) \sim Normal(\mu, \Sigma)}

The slots of this class contain the mean vector and the covariance matrix of
the bivariate normal distribution, as well as the reference dose.

Note that the parametrization inside the class uses alpha0 and alpha1.
alpha0 is identical to the intercept \eqn{\alpha} above and is the log-odds
for a DLT at the reference dose x*. Therefore, the prior mean for alpha0
is the expected log-odds at the reference dose x* before observing any data.
Note that the expected odds is not just the exp of the prior mean of alpha0,
because the non-linearity of the exp transformation. The log-normal
distribution on Wikipedia gives the formula for computing the prior mean of
exp(alpha0). alpha0 is the log(alpha) in the Neuenschwander et al. (2008)
paper. alpha1 is identical to \eqn{\beta} above and equals the beta
in the Neuenschwander et al paper. exp(alpha1) gives the odds-ratio for DLT
between two doses that differ by the factor exp(1) ~ 2.7. alpha1 has a
log-normal distribution in the LogisticLogNormal model in order to ensure
positivity of alpha1 and thus exp(alpha1) > 1.
}
\section{Slots}{

\describe{
\item{\code{mean}}{the prior mean vector \eqn{\mu}}

\item{\code{cov}}{the prior covariance matrix \eqn{\Sigma}}

\item{\code{refDose}}{the reference dose \eqn{x^{*}}}
}}

\examples{


model <- LogisticLogNormal(mean = c(-0.85, 1),
                           cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                           refDose = 50)


}
\keyword{classes}
