% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_gg2}
\alias{body_add_gg2}
\title{Alternative to \code{\link[officer:body_add_gg]{officer::body_add_gg()}} which uses \code{ggplot} syntax}
\usage{
body_add_gg2(
  doc,
  value,
  width = 6,
  height = 5,
  units = getOption("crosstable_units", "in"),
  style = getOption("crosstable_style_image", doc$default_styles$paragraph),
  res = 300,
  ...
)
}
\arguments{
\item{doc}{an \code{rdocx} object}

\item{value}{ggplot object}

\item{width, height}{width and height. Can be abbreviated to w and h.}

\item{units}{units for width and height}

\item{style}{paragraph style}

\item{res}{resolution of the png image in ppi (passed to the argument \code{dpi} of \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}})}

\item{...}{other arguments to be passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}}
}
\value{
The docx object \code{doc}
}
\description{
Alternative to \code{\link[officer:body_add_gg]{officer::body_add_gg()}} which uses \code{ggplot} syntax
}
\examples{
if(require("ggplot2") && capabilities(what = "png")){
  library(officer)
  p = ggplot(data = iris ) +
    geom_point(mapping = aes(Sepal.Length, Petal.Length))
  
  options(crosstable_units="cm")
  options(crosstable_style_image="centered")
  doc = read_docx() \%>\%
    body_add_normal("Text before") \%>\% 
    body_add_gg2(p, w=14, h=10, scale=1.5) \%>\% #or units="cm" instead of using options
    body_add_normal("Text after")
  #write_and_open(doc)
}
}
