% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{crosstable_options}
\alias{crosstable_options}
\title{Options for the package \code{crosstable}}
\usage{
crosstable_options(
  ...,
  zero_percent = FALSE,
  only_round = FALSE,
  verbosity_autotesting = "default",
  verbosity_duplicate_cols = "default",
  total,
  percent_pattern,
  percent_digits,
  num_digits,
  showNA,
  label,
  funs,
  funs_arg,
  cor_method,
  unique_numeric,
  date_format,
  times,
  followup,
  test_arg,
  effect_args,
  wrap_id = 70,
  compact_padding = 25,
  header_show_n_pattern = "{.col} (N={.n})",
  keep_id,
  autofit,
  compact,
  remove_header_keys,
  show_test_name,
  padding_v,
  header_show_n,
  fontsize_body,
  fontsize_subheaders,
  fontsize_header,
  units = "in",
  peek_docx = TRUE,
  font_code = "Consolas",
  add_max_cols = 25,
  format_legend_name,
  table_legend_par_before,
  table_legend_prefix,
  figure_legend_par_after,
  figure_legend_prefix,
  normal_squish,
  title_squish,
  allow_break,
  style_normal,
  style_character,
  style_strong,
  style_image,
  style_legend,
  style_heading,
  style_list_ordered,
  style_list_unordered,
  scientific_log,
  .local = FALSE,
  reset = deprecated()
)
}
\arguments{
\item{...}{unused}

\item{zero_percent}{set to TRUE so that proportions are not displayed if \code{n==0}}

\item{only_round}{default argument for \code{\link[=format_fixed]{format_fixed()}}}

\item{verbosity_autotesting}{one of \code{default}, \code{quiet}, or \code{verbose}}

\item{verbosity_duplicate_cols}{one of \code{default}, \code{quiet}, or \code{verbose}.}

\item{total}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{percent_pattern}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{percent_digits}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{num_digits}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{showNA}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{label}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{funs}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{funs_arg}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{cor_method}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{unique_numeric}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{date_format}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{times}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{followup}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{test_arg}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{effect_args}{For setting \code{\link[=crosstable]{crosstable()}} arguments globally.}

\item{wrap_id}{if \code{id} contains no spaces, wrap it with this maximum number of characters.}

\item{compact_padding}{in flextables, left-padding for non-headers rows when \code{compact=TRUE}.}

\item{header_show_n_pattern}{glue pattern used when showing N in the header of flextables. \code{.col} is the name of the column and \code{.n} the size of the group. Default to \code{{.col} (N={.n})}.}

\item{keep_id}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{autofit}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{compact}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{remove_header_keys}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{show_test_name}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{padding_v}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{header_show_n}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{fontsize_body}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{fontsize_subheaders}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally. Subheaders are only considered when \code{compact=TRUE}.}

\item{fontsize_header}{For setting \code{\link[=as_flextable]{as_flextable()}} arguments globally.}

\item{units}{default units in \code{\link[=body_add_gg2]{body_add_gg2()}} and \code{\link[=body_add_img2]{body_add_img2()}}}

\item{peek_docx}{behavior of \code{\link[=peek]{peek()}}, which will open a \code{docx} if \code{TRUE} (default) and an \code{xlsx} if \code{FALSE}}

\item{font_code}{font family used to show code, most likely a monospaced typeface such as Consolas (default)}

\item{add_max_cols}{max number of columns a crosstable can have to be added to a Word document}

\item{format_legend_name}{how the legend name ("Table", "Figure") is formatted. Default to \code{officer::fp_text_lite(bold=TRUE)}}

\item{table_legend_par_before}{whether to add an empty paragraph before all table legends}

\item{table_legend_prefix, figure_legend_prefix}{a prefix before each legend, after the numbering}

\item{figure_legend_par_after}{whether to add an empty paragraph after all figure legends}

\item{normal_squish}{Should you squish text in normal paragraphs?}

\item{title_squish}{Should you squish text in headers paragraphs?}

\item{allow_break}{allow crosstable rows to break across pages}

\item{style_normal}{For specifying styles used in your {officer} template.}

\item{style_character}{For specifying styles used in your {officer} template.}

\item{style_strong}{For specifying styles used in your {officer} template.}

\item{style_image}{For specifying styles used in your {officer} template.}

\item{style_legend}{For specifying styles used in your {officer} template.}

\item{style_heading}{For specifying styles used by headings on different levels. Levels will be pasted in the end (e.g. use \code{"title"} if your level 2 heading style is \code{"title2"}).}

\item{style_list_ordered, style_list_unordered}{For specifying styles used by lists in the \code{rdocx} template. Needed for \code{\link[=body_add_list]{body_add_list()}} to work.}

\item{scientific_log}{the maximum power a number can have before being formatted as scientific. Default to 4 so applies on numbers <1e-4 or >1e4.}

\item{.local}{if TRUE, the effect will only apply to the local frame (thanks to \code{rlang::local_options()})}

\item{reset}{if \code{TRUE}, set all these options back to default}
}
\value{
Nothing, called for its side effects
}
\description{
Use this function to manage your \code{crosstable} parameters globally while taking advantage of autocompletion. Use \code{\link[=crosstable_peek_options]{crosstable_peek_options()}} to see which option is currently set and \code{\link[=crosstable_reset_options]{crosstable_reset_options()}} to set all options back to default.
}
\seealso{
\code{\link[=crosstable_peek_options]{crosstable_peek_options()}} and \code{\link[=crosstable_reset_options]{crosstable_reset_options()}}
}
