% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{proxies}
\alias{proxies}
\alias{proxy}
\title{proxy options}
\usage{
proxy(url, user = NULL, pwd = NULL, auth = "basic")
}
\arguments{
\item{url}{(character) URL, with scheme (http/https), domain and
port (must be numeric). required.}

\item{user}{(character) username, optional}

\item{pwd}{(character) password, optional}

\item{auth}{(character) authentication type, one of basic (default),
digest, digest_ie, gssnegotiate, ntlm, or any. optional}
}
\description{
proxy options
}
\details{
See \url{http://proxylist.hidemyass.com/} for a list of proxies you
can use
}
\examples{
proxy("http://97.77.104.22:3128")
proxy("97.77.104.22:3128")
proxy("http://97.77.104.22:3128", "foo", "bar")
proxy("http://97.77.104.22:3128", "foo", "bar", auth = "digest")
proxy("http://97.77.104.22:3128", "foo", "bar", auth = "ntlm")

# with proxy (look at request/outgoing headers)
(res <- HttpClient$new(
  url = "http://www.google.com",
  proxies = proxy("http://97.77.104.22:3128")
))
res$proxies
\dontrun{res$get(verbose = TRUE)}

# vs. without proxy (look at request/outgoing headers)
(res2 <- HttpClient$new(url = "http://www.google.com"))
res2$get(verbose = TRUE)


# Use authentication
(res <- HttpClient$new(
  url = "http://google.com",
  proxies = proxy("http://97.77.104.22:3128", user = "foo", pwd = "bar")
))

# another example
(res <- HttpClient$new(
  url = "http://ip.tyk.nu/",
  proxies = proxy("http://200.29.191.149:3128")
))
\dontrun{res$get()$parse("UTF-8")}
}
