% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-dataset.R
\docType{methods}
\name{exportDataset}
\alias{exportDataset}
\alias{write.csv,CrunchDataset-method}
\title{Export a dataset to a file}
\usage{
exportDataset(dataset, file, format = c("csv", "spss"),
  categorical = c("name", "id"), na = NULL, varlabel = c("name",
  "description"), ...)

\S4method{write.csv}{CrunchDataset}(...)
}
\arguments{
\item{dataset}{CrunchDataset, which may have been subsetted with a filter
expression on the rows and a selection of variables on the columns.}

\item{file}{character local filename to write to}

\item{format}{character export format: currently supported values are "csv"
and "spss".}

\item{categorical}{character: export categorical values to CSV as category
"name" (default) or "id". Ignored by the SPSS exporter.}

\item{na}{Similar to the argument in \code{\link[utils]{write.table}}, 'na'
lets you control how missing values are written into the CSV file.
Supported values are (1) \code{NULL}, the default, which means that
categorical variables will have the category name or id as the value, and
numeric, text, and datetime variables will have the missing reason string;
(2) a string to use for missing values. \code{""} means that empty cells will
be written for missing values for all types.}

\item{varlabel}{For SPSS export, which Crunch metadata field should be used
as variable labels? Default is "name", but "description" is another valid
value.}

\item{...}{additional options. See the API documentation. Currently supported
boolean options include 'include_personal' for personal variables (default:
\code{FALSE}) and 'prefix_subvariables' for SPSS format: whether to include
the array variable's name in each of its subvariables varlabels (default:
\code{FALSE}).}
}
\value{
Invisibly, \code{file}.
}
\description{
Export a dataset to a file
}
