% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitables.R
\name{importMultitable}
\alias{importMultitable}
\title{Import a Multitable}
\usage{
importMultitable(data, multitable, ...)
}
\arguments{
\item{data}{an object of class \code{CrunchDataset} in which to create the
multitable}

\item{multitable}{an object of class \code{Multitable} that you want copied
to the new dataset}

\item{...}{Additional multitable attributes to set. Options include \code{name} and
\code{is_public}.}
}
\value{
An object of class \code{Multitable}
}
\description{
Allows you to import a multitable from a different dataset
}
\examples{
\dontrun{
m <- newMultitable(~ gender + age4 + marstat, data=ds)
copied_m <- importMultitable(another_ds, m)
name(copied_m) # [1] "gender + age4 + marstat"
}
}
