% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-data-frame.R
\name{dataset-to-R}
\alias{dataset-to-R}
\alias{as.data.frame.CrunchDataset}
\alias{as.data.frame.CrunchDataFrame}
\title{as.data.frame method for CrunchDataset}
\usage{
\method{as.data.frame}{CrunchDataset}(x, row.names = NULL, optional = FALSE,
  force = FALSE, categorical.mode = "factor", include.hidden = FALSE,
  row.order = NULL, ...)

\method{as.data.frame}{CrunchDataFrame}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{x}{a CrunchDataset}

\item{row.names}{part of as.data.frame signature. Ignored.}

\item{optional}{part of as.data.frame signature. Ignored.}

\item{force}{logical: actually coerce the dataset to \code{data.frame}, or
leave the columns as unevaluated promises. Default is \code{FALSE}.}

\item{categorical.mode}{what mode should categoricals be pulled as? One of
factor, numeric, id (default: factor)}

\item{include.hidden}{should hidden variables be included? (default: \code{FALSE})}

\item{row.order}{vector of indices. Which, and their order, of the rows of
the dataset should be presented as (default: \code{NULL}). If \code{NULL}, then the
Crunch Dataset order will be used.}

\item{...}{additional arguments passed to \code{as.data.frame} (default method).}
}
\value{
an object of class \code{CrunchDataFrame} unless \code{force}, in
which case the return is a \code{data.frame}.
}
\description{
This method is defined principally so that you can use a CrunchDataset as
a \code{data} argument to other R functions (such as \code{\link[stats:lm]{stats::lm()}}). By default,
the function does not return a \code{data.frame} but instead \code{CrunchDataFrame},  which
behaves similarly to a \code{data.frame} without bringing the whole dataset into memory.
When you access the variables of a \code{CrunchDataFrame},
you get an R vector, rather than a \code{CrunchVariable}. This allows modeling functions
that require select columns of a dataset to retrieve only those variables from
the remote server, rather than pulling the entire dataset into local
memory. You can override this behavior by passing \code{force = TRUE}, which will
cause the function to return a traditional \code{data.frame}.
}
