% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-datasets.R, R/projects.R
\name{datasets}
\alias{datasets}
\alias{datasets<-}
\title{Get a catalog of datasets}
\usage{
datasets(x = getAPIRoot())

datasets(x) <- value
}
\arguments{
\item{x}{a \code{ProjectFolder} or \code{SearchResults} that may contain datasets}

\item{value}{For assignment, a \code{CrunchDataset} to move}
}
\value{
When \code{x} is a \code{ProjectFolder}, \code{datasets()} returns the folder with
its "index" filtered to contain only datasets; otherwise, it returns an
object of class \code{DatasetCatalog}. The assignment function returns the
project \code{x} with the given dataset added to it.
}
\description{
Crunch datasets are collected in folders called "projects". \code{datasets()} can
be used to filter a project's contents to see only datasets (and not other
projects). You can also use it to pull a catalog of datasets from search
results.
}
\details{
The \verb{datasets()<-} assignment function provides an alternative method for
moving a dataset into a project. This may be more convenient in some cases
than using \code{\link[=mv]{mv()}}.
}
\examples{
\dontrun{
# Get the names of the datasets contained in a project
projects() \%>\%
    cd("Important Clients") \%>\%
    datasets() \%>\%
    names()
# The assignment method lets you move a dataset to a project
proj <- cd(projects(), "Important Clients")
ds <- loadDataset("New important client survey")
datasets(proj) <- ds
}
}
