% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-when-variable.R
\name{makeCaseWhenVariable}
\alias{makeCaseWhenVariable}
\alias{caseWhenExpr}
\title{Create a categorical or numeric variable based on conditions}
\usage{
makeCaseWhenVariable(..., data = NULL, cases = NULL, name, type = NULL)

caseWhenExpr(..., data = NULL, cases = NULL, type = NULL)
}
\arguments{
\item{...}{formulas where the left hand side is a \code{CrunchLogicalExpression} (or \code{TRUE}
to indicate the "else" case that will be met if all the other expression are
not met) and the right hand side is a CrunchVariable that should be filled in,
a \code{Category} object describing the Category it should be used, a string
which will be the name of the \code{Category} or \code{NA} to indicate that it should
be replaced with the system missing value. For \code{makeCaseWhenVariable()}
non-formula arguments will be passed to \verb{[VarDef()]}}

\item{data}{A CrunchDataset to use if variable aliases are left bare in the
formulas.}

\item{cases}{A list of formulas that match the description in \code{...} or a list of
lists with named items, "expression" (like the left-hand side of the formulas above),
"fill" for a variable to fill in, or "name", "id", and other items that describe a
category.}

\item{name}{For \code{makeCaseWhenVariable()} the name of the variable to create.}

\item{type}{The type of the variable to output (either "categorical" or "numeric"), only
required if all fills are expressions and so their type cannot be guessed automatically.}
}
\value{
\code{makeCaseWhenVariable()} returns a \code{VariableDefinition} and
\code{caseWhenExpr()} returns an expression
}
\description{
Conditions are specified using a series of formulas: the left-hand side is
the condition that must be true (a \code{CrunchLogicalExpr}) and the right-hand
side is where to get the value if the condition on the left-hand side is
true. When creating a categorical variable, the right-hand side must be
a \code{Category} or a categorical \code{CrunchVariable} or \code{CrunchExpression}, while
for numeric variables it is a single number or variable or expression.
}
\examples{
\dontrun{
# Creating categorical variables
ds$new_var <- makeCaseWhenVariable(
   ds$x \%in\% c("a", "b") ~ ds$y, # can fill with a variable
   ds$x \%in\% c("c", "d") ~ Category(name = "c or d", numeric_value = 10), # or a Category
   # If none of the categories match, will be set to missing unless you
   # specify an "else" case with `TRUE` in the left hand side
   TRUE ~ Category(name = "catch all"),
   name = "combined x and y"
)

ds$brand_x_pref <- makeCaseWhenVariable(
   ds$brand[[1]] == "Brand X" ~ ds$pref[[1]],
   ds$brand[[2]] == "Brand X" ~ ds$pref[[2]],
   ds$brand[[3]] == "Brand X" ~ ds$pref[[3]],
   name = "brand x preference"
)

ds$x_among_aware <- makeCaseWhenVariable(
   ds$aware_x == "Yes" ~ ds$x,
   TRUE ~ Category(name = "(Not aware)", missing = TRUE),
   name = "x (among respondents aware of x)"
)

ds$new_num_var <- makeCaseWhenVariable(
  ds$x \%in\% c("a", "b") ~ ds$z, # LHS as before, RHS can be numeric variables,
  ds$x == "c" ~ ds$z * 10, # expressions,
  ds$x == "d" ~ 100, # or numbers
  name = "New numeric variable"
)

ds$capped_z <- makeCaseWhenVariable(
  ds$z > 10 ~ 10,
  TRUE ~ ds$z,
  name = "Capped z"
)

# caseWhenExpr can be used inside other expressions
ds$brand_x_prefer_high <- VarDef(
   selectCategories(
       caseWhenExpr(
           ds$brand_shown[[1]] == "Brand X" ~ ds$ratings[[1]],
           ds$brand_shown[[2]] == "Brand X" ~ ds$ratings[[2]],
           ds$brand_shown[[3]] == "Brand X" ~ ds$ratings[[3]]
       ),
       c("Best", "Very Good")
   ),
   name = "Rate X highly"
)

# Using lists in `cases` argument can be helpful when working programmatically
source_var <- ds$x
inclusion_condition <- ds$skipped_x != "Yes"

ds$x2_among_aware <- makeCaseWhenVariable(
   cases = list(list(fill = source_var, expression = inclusion_condition)),
   name = "x2 among aware"
)
}
}
