% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{setupCrunchAuth}
\alias{setupCrunchAuth}
\title{Helper for switching between API keys and urls}
\usage{
setupCrunchAuth(id)
}
\arguments{
\item{id}{A string indicating the id of the credentials}
}
\description{
Credentials can be stored in the options or environment variables with the following
structure (option = \verb{crunch.api.<ID>} or environment variable \verb{R_CRUNCH_API_<ID>}) where
\verb{<ID>} is a string. Then you can use this function to choose which credentials you want to use.
}
\examples{
\dontrun{
# Using crunch options:
set_crunch_opts(
    crunch.api.account1 = "https://company1.crunch.io/api/",
    crunch.api.key.account1 = "MY KEY"
)

# Or with environment variables
Sys.setenv(
    "R_CRUNCH_API_ACCOUNT2" = "https://company2.crunch.io/api/",
    "R_CRUNCH_API_KEY_ACCOUNT2" = "ANOTHER KEY"
)

# Can now switch between accounts
setupCrunchAuth("account1")
crunch_sitrep()

setupCrunchAuth("account2")
crunch_sitrep()
}

}
