% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smREFL.R
\name{readsm_REFL}
\alias{readsm_REFL}
\title{Reads and output an CIF file}
\usage{
readsm_REFL(filename, message = FALSE)
}
\arguments{
\item{filename}{A character string. The path to a valid small molecule
reflection file. Typically a hkl or an fcf file.}

\item{message}{A logical variable. If TRUE (default) the function prints
a message highlighting what is included in the cif file.}
}
\value{
A named list. Each name correspond to a valid field in the fcf or hkl file.
}
\description{
Reads and output an CIF file
}
\examples{
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"1dei-sf.cif")
lCIF <- readsm_REFL(filename)
print(names(lCIF))
print(lCIF$INTRO$CELL)
print(lCIF$SYMM)
print(lCIF$REFL)
}
