% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addMACD}
\alias{addMACD}
\title{Add MACD indicators to the chart}
\usage{
addMACD(chart, ...)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}

\item{...}{See \code{\link[TTR:MACD]{TTR::MACD()}}}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Traders and investors use the MACD indicator to identify trend changes, potential reversals, and overbought or oversold conditions in the market.
It is a versatile tool that can be applied to various timeframes and asset classes, making it a valuable part of technical analysis for many traders.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addLSRatio}()},
\code{\link{addMA}()},
\code{\link{addRSI}()},
\code{\link{addVolume}()},
\code{\link{chart}()}
}
\concept{chart indicators}
