% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{ohlc}
\alias{ohlc}
\title{chart quote using
ohlc bars}
\usage{
ohlc(quote, deficiency = FALSE, slider = TRUE)
}
\arguments{
\item{quote}{A cryptoQuote in xts/zoo format.}

\item{deficiency}{Logical. FALSE by default, if TRUE color defiency compliant
colors are used.}

\item{slider}{Logical. TRUE by default. If FALSE, no slider will be included.}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Traders and analysts use OHLC bar charts to analyze price action, identify trends, support and resistance levels, and potential reversal patterns.
They are especially useful for assessing the relationship between the opening and closing prices
within a given time frame, which can offer insights into market sentiment and potential future price movements.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other charting: 
\code{\link{chart}()},
\code{\link{kline}()}
}
\concept{charting}
