% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_toc.R
\name{cso_get_toc}
\alias{cso_get_toc}
\title{Returns a data frame with all valid CSO PxStat tables listed sequentially
by id number, e.g. A0101, A0102, A0103, etc.}
\usage{
cso_get_toc(
  cache = FALSE,
  suppress_messages = FALSE,
  get_frequency = FALSE,
  list_vars = FALSE,
  flush_cache = TRUE,
  from_date = "YYYY-MM-DD"
)
}
\arguments{
\item{cache}{logical. If TRUE the table of contents is cached
with the system date as a key.}

\item{suppress_messages}{logical. If FALSE (default) a message is printed
when loading a previously cached table of contents.}

\item{get_frequency}{logical. If TRUE the frequency of each 
table(yearly, monthly etc...) will be returned as an additional column in 
the table of contents.}

\item{list_vars}{logical. If TRUE an additional column will be added
to the table of contents which lists each tables variables.}

\item{flush_cache}{logical. If TRUE (default) the cache will be checked for 
old, unused files. Any files which have not been accessed in the last month 
will be deleted.}

\item{from_date}{date in the format YYYY-MM-DD or Null. Will only return tables last modified after date provided. Default is 2 years from current date.}
}
\value{
data frame of three character columns:
\itemize{
  \item id. Contains all of the table codes currently
available on the CSO API.
  \item LastModified. The date the table was last modified in POSIXct
  format.
  \item title. The title of the table.
}
}
\description{
Checks the CSO PxStat API for a list of all the table codes (e.g. A0101,
A0102, A0103, etc.), which also includes date last modified and title for
each table, and returns this list as an R data frame.
}
\details{
The data is pulled from the ReadCollection on the CSO API. See
\url{https://github.com/CSOIreland/PxStat/wiki/API-Cube-RESTful}
for more information on this.
}
\examples{
\dontrun{
head(cso_get_toc())
}
}
