% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctModelLatex.R
\name{ctModelLatex}
\alias{ctModelLatex}
\title{Generate and optionally compile latex equation of subject level ctsem model.}
\usage{
ctModelLatex(
  x,
  matrixnames = TRUE,
  digits = 3,
  linearise = class(x) \%in\% "ctStanFit",
  textsize = "normalsize",
  folder = tempdir(),
  filename = paste0("ctsemTex", as.numeric(Sys.time())),
  tex = TRUE,
  equationonly = FALSE,
  compile = TRUE,
  open = TRUE,
  minimal = FALSE
)
}
\arguments{
\item{x}{ctsem model object or ctStanFit object.}

\item{matrixnames}{Logical. If TRUE, includes ctsem matrix names such as DRIFT and DIFFUSION under the matrices.}

\item{digits}{Precision of decimals for numeric values.}

\item{linearise}{Logical. Show the linearised normal approximation for subject parameters and 
covariate effects, or the raw parameters?}

\item{textsize}{Standard latex text sizes -- 
tiny scriptsize footnotesize small normalsize large Large LARGE huge Huge. 
Useful if output overflows page.}

\item{folder}{Character string specifying folder to save to, defaults to temporary directory, use "./" for working directory.}

\item{filename}{filename, without suffix, to output .tex and .pdf files too.}

\item{tex}{Save .tex file? Otherwise latex is simply returned within R as a string.}

\item{equationonly}{Logical. If TRUE, output is only the latex relevant to the equation, not a compileable document.}

\item{compile}{Compile to .pdf? (Depends on \code{tex = TRUE})}

\item{open}{Open after compiling? (Depends on \code{compile = TRUE})}

\item{minimal}{if TRUE, outputs reduced form version displaying matrix dimensions and equation structure only.}
}
\value{
character string of latex code. Side effects include saving a .tex, .pdf, and displaying the pdf.
}
\description{
Generate and optionally compile latex equation of subject level ctsem model.
}
\examples{
ctmodel <- ctModel(type='stanct', 
n.latent=2, n.manifest=1, 
manifestNames='sunspots', 
latentNames=c('ss_level', 'ss_velocity'),
LAMBDA=matrix(c( 1, 'ma1' ), nrow=1, ncol=2),
DRIFT=matrix(c(0, 1,   'a21', 'a22'), nrow=2, ncol=2, byrow=TRUE),
MANIFESTMEANS=matrix(c('m1'), nrow=1, ncol=1),
CINT=matrix(c(0, 0), nrow=2, ncol=1),
DIFFUSION=matrix(c(
  0, 0,
  0, "diffusion"), ncol=2, nrow=2, byrow=TRUE))
  
l=ctModelLatex(ctmodel,compile=FALSE, open=FALSE)
cat(l)
}
