% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramers_vi.R
\encoding{UTF-8}
\name{cramers_vi}
\alias{cramers_vi}
\title{Computes the Cramer's vi of a categorical time series}
\usage{
cramers_vi(series, lag = 1, categories, features = FALSE)
}
\arguments{
\item{series}{A CTS.}

\item{lag}{The considered lag (default is 1).}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of the Cramer's vi is returned. Otherwise, the function
returns a matrix with the individual components of the Cramer's vi.}
}
\value{
If \code{features = FALSE} (default), returns the value of the Cramer's vi. Otherwise, the function
returns a matrix of features, i.e., the matrix contains the features employed to compute the
Cramer's vi.
}
\description{
\code{cramers_vi} returns the value of the Cramer's vi for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated Cramer's vi, \eqn{\widehat{v}(l)=\sqrt{\frac{1}{r-1}\sum_{i,j=1}^r\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}}},
where \eqn{\widehat{p}_i} is the natural estimate of the marginal probability of the \eqn{i}th
category, and \eqn{\widehat{p}_{ij}(l)} is the natural estimate of the joint probability
for categories \eqn{i} and \eqn{j} at lag l, \eqn{i,j=1, \ldots, r}. If \code{features = TRUE}, the function
returns the same output as the function \code{\link{pearson_measure}}.
}
\examples{
cv <- cramers_vi(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the Cramer's vi
# for the first series in dataset GeneticSequences
feature_matrix <- cramers_vi(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't')), features = TRUE) # Computing the corresponding
# matrix of features
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
