% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cohen.R
\encoding{UTF-8}
\name{plot_cohen}
\alias{plot_cohen}
\title{Constructs a serial dependence plot based on Cohen's kappa}
\usage{
plot_cohen(
  series,
  max_lag = 10,
  alpha = 0.05,
  plot = TRUE,
  title = "Serial dependence plot",
  bar_width = 0.12,
  ...
)
}
\arguments{
\item{series}{An object of type \code{tsibble} (see R package \code{tsibble}), whose column named Values
contains the values of the corresponding CTS. This column must be of class \code{factor} and its levels
must be determined by the range of the CTS.}

\item{max_lag}{The maximum lag represented in the plot (default is 10).}

\item{alpha}{The significance level for the corresponding hypothesis test (default is 0.05).}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the serial dependence
plot. Otherwise, returns a list with the values of Cohens's kappa, the critical
value and the corresponding p-values.}

\item{title}{The title of the graph.}

\item{bar_width}{The width of the corresponding bars.}

\item{...}{Additional parameters for the function.}
}
\value{
If \code{plot = TRUE} (default), returns the serial dependence plot based on Cohens's kappa. Otherwise, the function
returns a list with the values of Cohens's kappa, the critical
value and the corresponding p-values.
}
\description{
\code{plot_cohen} constructs a serial dependence plot of a categorical
time series based on Cohen's kappa
}
\details{
Constructs a serial dependence plot based on Cohens's kappa, \eqn{\widehat{\kappa}(l)},
for several lags. A dashed lined is incorporated indicating the critical value
of the test based on the following asymptotic approximation (under the i.i.d. assumption):
\deqn{\sqrt{\frac{T}{V(\widehat{\boldsymbol p})}}\bigg(\widehat{\kappa}(l)+\frac{1}{T}\bigg)\sim N\big(0, 1\big),} where \eqn{T} is the series length,
\eqn{\widehat{\boldsymbol p}=(\widehat{p}_1, \ldots, \widehat{p}_r)} is the vector of estimated marginal probabilities for the \eqn{r} categories of
the series and \eqn{V(\boldsymbol {\widehat{p}})=1-\frac{1+2\sum_{i=1}^{r}\widehat{p}_i^3-3\sum_{i=1}^{r}\widehat{p}_i^2}{(1-\sum_{i=1}^{r}\widehat{p}_i^2)^2}}.
}
\examples{
sequence_1 <- GeneticSequences[which(GeneticSequences$Series==1),]
plot_ck <- plot_cohen(series = sequence_1, max_lag = 3) # Representing
# the serial dependence plot
list_ck <- plot_cohen(series = sequence_1, max_lag = 3, plot = FALSE) # Obtaining
# the values of Cohens's kappa, the critical value and the p-values
}
\references{
{

  \insertRef{weiss2011empirical}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
