% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_mrv_batch}
\alias{get_chemical_mrv_batch}
\title{Ger mrv file by DTXSID or DTXCID batch}
\usage{
get_chemical_mrv_batch(
  DTXSID = NULL,
  DTXCID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A list of the chemical identifier DTXSIDs.}

\item{DTXCID}{A list of the chemical identifier DTXCIDs.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of XML file format for representing a mrv file for each
chemicals.
}
\description{
Ger mrv file by DTXSID or DTXCID batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull mrv files for multiple chemicals by DTXSID
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
mrv_files <- get_chemical_mrv_batch(DTXSID = dtxsid)
# Pull mrv files for multiple chemicals by DTXCID
dtxcid <- c('DTXCID30182', 'DTXCID001315')
mrv_files <- get_chemical_mrv_batch(DTXCID = dtxcid)
\dontshow{\}) # examplesIf}
}
