% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-utf.R
\name{read_str}
\alias{read_str}
\alias{read_str_raw}
\alias{read_utf8}
\alias{read_utf8_raw}
\title{Read a character string from a connection}
\usage{
read_str(con)

read_str_raw(con, n)

read_utf8(con)

read_utf8_raw(con, n)
}
\arguments{
\item{con}{Connection object or raw vector. Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{n}{number of characters to read.}
}
\value{
single character string
}
\description{
Read character string from a connection.
}
\details{
Functions which have a suffix of \code{_raw} are for handling character 
strings without a nul-terminator.
}
\examples{
con <- rawConnection(c(charToRaw("hello12.3"), as.raw(0)))
read_str(con)
close(con)

con <- rawConnection(charToRaw("hello12.3"))
read_str_raw(con, 5)
close(con)

con <- rawConnection(c(charToRaw("hello12.3"), as.raw(0)))
read_utf8(con)
close(con)

con <- rawConnection(charToRaw("hello12.3"))
read_utf8_raw(con, 3)
close(con)
}
\seealso{
Other data input functions: 
\code{\link{read_f64}()},
\code{\link{read_hex}()},
\code{\link{read_raw}()},
\code{\link{read_uint8}()},
\code{\link{scan_dbl}()}
}
\concept{data input functions}
