% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{check_cds}
\alias{check_cds}
\title{Quality control of CDS}
\usage{
check_cds(
  seqs,
  codon_table = get_codon_table(),
  min_len = 6,
  check_len = TRUE,
  check_start = TRUE,
  check_stop = TRUE,
  check_istop = TRUE,
  rm_start = TRUE,
  rm_stop = TRUE,
  start_codons = c("ATG")
)
}
\arguments{
\item{seqs}{input CDS sequences}

\item{codon_table}{codon table matching the genetic code of \code{seqs}}

\item{min_len}{minimum CDS length in nt}

\item{check_len}{check whether CDS length is divisible by 3}

\item{check_start}{check whether CDSs have start codons}

\item{check_stop}{check whether CDSs have stop codons}

\item{check_istop}{check internal stop codons}

\item{rm_start}{whether to remove start codons}

\item{rm_stop}{whether to remove stop codons}

\item{start_codons}{vector of start codons}
}
\value{
DNAStringSet of filtered (and trimmed) CDS sequences
}
\description{
\code{check_cds} performs quality control of CDS sequences by filtering some
peculiar sequences and optionally remove start or stop codons.
}
\examples{
# CDS sequence QC for a sample of yeast genes
s <- head(yeast_cds, 10)
print(s)
check_cds(s)

}
