% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate_aus}
\alias{climate_aus}
\alias{historical_tmax}
\title{Australia climate data}
\format{
An object of class \code{spatial_cubble_df} (inherits from \code{cubble_df}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 639 rows and 7 columns.

An object of class \code{spatial_cubble_df} (inherits from \code{cubble_df}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 75 rows and 7 columns.
}
\usage{
climate_aus

historical_tmax
}
\description{
\code{climate_aus}: daily measure on precipitation (\code{prcp}),
maximum temperature (\code{tmax}), and minimum temperature (\code{tmin})
in 2020 for 639 stations. \code{historical_tmax}: daily maximum temperature
(\code{tmax}) for 75 stations in Victoria and New South Wales for two
periods: 1971-1975 and 2016-2020.
}
\details{
\describe{
\item{id}{station ID, "ASN000" are international paddings, the next
two digits (digit 8-9) indicates the states the station is in:
Western Australia: 01-13, Northern Territory: 14-15, South Australia:
16-26, Queensland: 27-45, New South Wales: 46-75, Victoria: 76-90,
Tasmania: 91-99.
See http://www.bom.gov.au/climate/cdo/about/site-num.shtml}
\item{lat}{latitude of the stations, in degree}
\item{long}{longitude of the stations, in degree}
\item{elev}{elevation of the stations}
\item{name}{station name}
\item{wmo_id}{the world meteorological organisation (WMO) station number}
\item{ts}{For \code{climate_aus}: date, prcp, tmax, and tmin, for
\code{historical_tmax}: date and tmax}
}
}
\examples{
climate_aus |> face_temporal() |> face_spatial()
}
\keyword{datasets}
