% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Npct.R
\docType{methods}
\name{Npct}
\alias{Npct}
\alias{Npct,logical,missing-method}
\alias{Npct,logical,logical-method}
\alias{Npct,integer,integer-method}
\alias{Npct,numeric,numeric-method}
\title{Combine count with a percent}
\usage{
Npct(x, n, ...)

\S4method{Npct}{logical,missing}(x, n, ...)

\S4method{Npct}{logical,logical}(x, n, ...)

\S4method{Npct}{integer,integer}(x, n, ...)

\S4method{Npct}{numeric,numeric}(x, n, ...)
}
\arguments{
\item{x}{count or object to count}

\item{n}{see methods.}

\item{...}{formatting arguments for formatting the percent. See format.percent.}
}
\value{
A character vector formatted with number and percent of successes.
}
\description{
Combine count with a percent
}
\section{Methods (by class)}{
\itemize{
\item \code{x = logical,n = missing}: Count and give percent of \code{TRUE} from a logical vector.

\item \code{x = logical,n = logical}: Count and percent of a logical filtered by a second logical.

\item \code{x = integer,n = integer}: Provided with count(s) of cases and total(s)

\item \code{x = numeric,n = numeric}: Provided the actual count and the percent.
}}

\examples{
# Vector of cases only.
Npct(c(TRUE, FALSE, TRUE))

# Cases with indices
Npct( c(TRUE,FALSE,TRUE,FALSE,TRUE), c(TRUE,TRUE,TRUE,FALSE,FALSE))

# Successes/Total
Npct(2L, 3L)

# Count + percent directly, count must be integerish.
Npct(2, 2/3)

}
