% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cohens_kappa}
\alias{cohens_kappa}
\title{Calculate Cohen's Kappa}
\usage{
cohens_kappa(tp, fp, tn, fn, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}

\item{fn}{(numeric) number of false negatives.}

\item{...}{for capturing additional arguments passed by method.}
}
\value{
A numeric matrix with the column name "cohens_kappa".
}
\description{
Calculate the Kappa metric from
true positives, false positives, true negatives and false negatives.
The inputs must be vectors of equal length. \cr \cr
mrg_a = ((tp + fn) * (tp + fp)) / (tp + fn + fp + tn) \cr
mrg_b = ((fp + tn) * (fn + tn)) / (tp + fn + fp + tn) \cr
expec_agree = (mrg_a + mrg_b) / (tp + fn + fp + tn) \cr
obs_agree = (tp + tn) / (tp + fn + fp + tn) \cr
cohens_kappa = (obs_agree - expec_agree) / (1 - expec_agree) \cr
}
\examples{
cohens_kappa(10, 5, 20, 10)
cohens_kappa(c(10, 8), c(5, 7), c(20, 12), c(10, 18))
}
\seealso{
Other metric functions: \code{\link{F1_score}},
  \code{\link{abs_d_ppv_npv}},
  \code{\link{abs_d_sens_spec}}, \code{\link{accuracy}},
  \code{\link{cutpoint}},
  \code{\link{false_omission_rate}},
  \code{\link{misclassification_cost}}, \code{\link{npv}},
  \code{\link{odds_ratio}}, \code{\link{p_chisquared}},
  \code{\link{plr}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{prod_ppv_npv}},
  \code{\link{prod_sens_spec}}, \code{\link{recall}},
  \code{\link{risk_ratio}}, \code{\link{sensitivity}},
  \code{\link{specificity}}, \code{\link{sum_ppv_npv}},
  \code{\link{sum_sens_spec}}, \code{\link{total_utility}},
  \code{\link{tpr}}, \code{\link{tp}}, \code{\link{youden}}
}
