% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{robustPoetEst}
\alias{robustPoetEst}
\title{Robust POET Estimator for Elliptical Distributions}
\usage{
robustPoetEst(dat, k, lambda, var_est = c("sample", "mad", "huber"))
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}

\item{k}{An \code{integer} indicating the number of unobserved latent
factors. Empirical evidence suggests that the POET estimator is robust to
overestimation of this hyperparameter \insertCite{fan2013}{cvCovEst}. In
practice, it is therefore preferable to use larger values.}

\item{lambda}{A non-negative \code{numeric} defining the amount of
thresholding applied to each element of sample covariance matrix's
orthogonal complement.}

\item{var_est}{A \code{character} dictating which variance estimator to
use. This must be one of the strings \code{"sample"}, \code{"mad"}, or
\code{"huber"}. \code{"sample"} uses sample variances; \code{"mad"}
estimates variances via median absolute deviation; \code{"huber"} uses an
M-estimator for variance under the Huber loss.}
}
\value{
A \code{matrix} corresponding to the estimate of the covariance
matrix.
}
\description{
\code{robustPoetEst()} implements the robust version of
Principal Orthogonal complEment Thresholding (POET) estimator, a
nonparametric, unobserved-factor-based estimator of the covariance matrix
when the underlying distribution is elliptical
\insertCite{fan2018}{cvCovEst}. The estimator is defined as the sum of the
sample covariance matrix's rank-\code{k} approximation and its
post-thresholding principal orthogonal complement. The rank-\code{k}
approximation is constructed from the sample covariance matrix, its leading
eigenvalues, and its leading eigenvectors.  The sample covariance matrix and
leading eigenvalues are initially estimated via an M-estimation procedure
and the marginal Kendall's tau estimator. The leading eigenvectors are
estimated using spatial Kendall's tau estimator. The hard thresholding
function is used to regularize the idiosyncratic errors' estimated
covariance matrix, though other regularization schemes could be used.

We do not recommend that this estimator be employed when
the estimand is the correlation matrix. The diagonal entries of the
resulting estimate are not guaranteed to be equal to one.
}
\examples{
robustPoetEst(dat = mtcars, k = 2L, lambda = 0.1, var_est = "sample")
}
\references{
\insertAllCited{}
}
