% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{cvap_get}
\alias{cvap_get}
\title{Download Processed Citizen Voting Age Population Data}
\usage{
cvap_get(
  state,
  year = 2021,
  geography = "block group",
  out_file = NULL,
  moe = FALSE,
  clean = TRUE
)
}
\arguments{
\item{state}{character. The state to get data for or nation for the nation file.}

\item{year}{numeric. Year for the data in 2009 to 2021.}

\item{geography}{character. Level of geography. Default is 'block group'. See Details.}

\item{out_file}{file to save downloaded rds to}

\item{moe}{Include margin of error? Default is FALSE.}

\item{clean}{Should variable names be standardized? Default is TRUE.}
}
\value{
tibble of data
}
\description{
Downloads processed CVAP data for a state. CVAP data is rounded to the nearest 5
so totals may not sum properly, but will be close.
}
\details{
Geography options are
\itemize{
\item 'block group': block group level data
\item 'cd': congressional district data (years 2016+)
\item 'county': county-level data
\item 'place': place-level data
\item shd': state house district data (years 2016+)
\item 'ssd': state senate district data (years 2016+)
\item 'state': state-level data
\item 'tract': tract-level data
\item 'nation': nation-wide data
}
}
\examples{
cvap_get('DE')
}
\concept{download}
