% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\name{solver}
\alias{solver}
\alias{solver,ANY-method}
\alias{solver,GutsRedSd-method}
\alias{solver,GutsRedIt-method}
\alias{solver,LemnaSchmittScenario-method}
\alias{solver,LemnaSetacScenario-method}
\alias{solver,MyrioExpScenario-method}
\alias{solver,MyrioLogScenario-method}
\alias{solver,DebAbj-method}
\alias{solver,DebDaphnia-method}
\alias{solver,AlgaeWeberScenario-method}
\alias{solver,AlgaeTKTDScenario-method}
\alias{solver,AlgaeSimpleScenario-method}
\title{Calls ODE solver for a particular model}
\usage{
solver(scenario, times, ...)

\S4method{solver}{ANY}(scenario, times, ...)

\S4method{solver}{GutsRedSd}(scenario, times, ...)

\S4method{solver}{GutsRedIt}(scenario, times, ...)

\S4method{solver}{LemnaSchmittScenario}(scenario, times, ...)

\S4method{solver}{LemnaSetacScenario}(scenario, times, ...)

\S4method{solver}{MyrioExpScenario}(scenario, times, ...)

\S4method{solver}{MyrioLogScenario}(scenario, times, ...)

\S4method{solver}{DebAbj}(scenario, times, ...)

\S4method{solver}{DebDaphnia}(
  scenario,
  times,
  approx = c("linear", "constant"),
  f = 1,
  method = "ode45",
  ...
)

\S4method{solver}{AlgaeWeberScenario}(
  scenario,
  times,
  approx = c("linear", "constant"),
  rule = 2,
  f = 1,
  method = "lsoda",
  hmax = 0.1,
  ...
)

\S4method{solver}{AlgaeTKTDScenario}(
  scenario,
  times,
  approx = c("linear", "constant"),
  rule = 2,
  f = 1,
  method = "lsoda",
  hmax = 0.1,
  ...
)

\S4method{solver}{AlgaeSimpleScenario}(
  scenario,
  times,
  approx = c("linear", "constant"),
  rule = 2,
  f = 1,
  method = "ode45",
  hmax = 0.01,
  ...
)
}
\arguments{
\item{scenario}{\link{scenario} object}

\item{times}{numeric vector of output times, overrides any scenario setting}

\item{...}{additional parameters passed on to \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{approx}{string, interpolation method of exposure series, see \code{\link[stats:approxfun]{stats::approxfun()}}}

\item{f}{if \code{approx="constant"}, a number between 0 and 1 inclusive, see \code{\link[stats:approxfun]{stats::approxfun()}}}

\item{method}{string, numerical solver used by \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{rule}{how to handle data points outside of time-series, see \link[deSolve:forcings]{deSolve::forcings}}

\item{hmax}{numeric, maximum step length in time, see \code{\link[deSolve:ode]{deSolve::ode()}}}
}
\value{
\code{data.frame} with simulation results
}
\description{
Please refer to the \emph{Modeling Howto} vignette on how to implement custom
models by overloading the \code{solver} function.
}
\section{Methods (by class)}{
\itemize{
\item \code{solver(ANY)}: Default solver, raises an error

\item \code{solver(GutsRedSd)}: Numerically integrates GUTS-RED-SD models

\item \code{solver(GutsRedIt)}: Numerically integrates GUTS-RED-IT models

\item \code{solver(LemnaSchmittScenario)}: Numerically integrates Lemna_Schmitt models

\item \code{solver(LemnaSetacScenario)}: Numerically integrates Lemna_SETAC models

\item \code{solver(MyrioExpScenario)}: Numerically integrates Myrio models

\item \code{solver(MyrioLogScenario)}: Numerically integrates Myrio_log models

\item \code{solver(DebAbj)}: Numerically integrates DEB_abj models

\item \code{solver(DebDaphnia)}: Numerically integrates DEB_Daphnia models

\item \code{solver(AlgaeWeberScenario)}: numerically integrates Algae_Weber models

\item \code{solver(AlgaeTKTDScenario)}: numerically integrates Algae_TKTD models

\item \code{solver(AlgaeSimpleScenario)}: numerically integrates Algae_Simple models

}}
