% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ExposureSeries.R
\name{no_exposure}
\alias{no_exposure}
\title{Zero exposure}
\usage{
no_exposure()
}
\value{
an S4 object of type \linkS4class{ExposureSeries}
}
\description{
Creates an \link{ExposureSeries} with zero concentration. When setting
the zero exposure, pay attention not to accidentally reset the output times
of your scenario as the zero exposure series contains only a single time point.
See the examples.
}
\examples{
# this will reset the output times of the sample scenario,
# simulate() will quit with an error
try(
  minnow_it \%>\%
    set_exposure(no_exposure()) \%>\%
    simulate()
)

# set zero exposure, but keep original output times
minnow_it \%>\%
  set_exposure(no_exposure(), reset_times=FALSE) \%>\%
  simulate()
}
\seealso{
\code{\link[=set_noexposure]{set_noexposure()}}
}
