% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmaPLFAM.R
\name{cvmaPLFAM}
\alias{cvmaPLFAM}
\title{Cross-Validation Model Averaging (CVMA) for Partial Linear Functional Additive Models (PLFAMs)}
\usage{
cvmaPLFAM(
  Y,
  scalars,
  functional,
  Y.test = NULL,
  scalars.test = NULL,
  functional.test = NULL,
  tt,
  nump,
  numfpcs,
  nbasis,
  nfolds,
  ratio.train = NULL
)
}
\arguments{
\item{Y}{The vector of the scalar response variable.}

\item{scalars}{The design matrix of scalar predictors.}

\item{functional}{The matrix including records/measurements of the functional predictor.}

\item{Y.test}{Test data: The vector of the scalar response variable.}

\item{scalars.test}{Test data: The design matrix of scalar predictors.}

\item{functional.test}{Test data: The matrix including records/measurements of the functional predictor.}

\item{tt}{The vector of recording/measurement points for the functional predictor.}

\item{nump}{The number of scalar predictors in candidate models.}

\item{numfpcs}{The number of functional principal components (FPCs) for the functional predictor in candidate models.}

\item{nbasis}{The number of basis functions used for spline approximation.}

\item{nfolds}{The number of folds used in cross-validation.}

\item{ratio.train}{The ratio of data for training, if test data are \code{NULL}.}
}
\value{
A \code{list} of
    \item{aic}{Mean squared error risk in training data set, produced by AIC model selection method.}
    \item{bic}{Mean squared error risk in training data set, produced by BIC model selection method.}
    \item{saic}{Mean squared error risk in training data set, produced by SAIC model averaging method.}
    \item{sbic}{Mean squared error risk in training data set, produced by SBIC model averaging method.}
    \item{cv}{Mean squared error risk in training data set, produced by CVMA method.}
    \item{waic}{The selected candidate model by AIC model selection method.}
    \item{wbic}{The selected candidate model by BIC model selection method.}
    \item{wsaic}{The weights for each candidate model by SAIC model averaging method.}
    \item{wsbic}{The weights for each candidate model by SBIC model averaging method.}
    \item{wcv}{The weights for each candidate model by CVMA method.}
    \item{predaic}{Mean squared prediction error risk in test data set, produced by AIC model selection method.}
    \item{predbic}{Mean squared prediction error risk in test data set, produced by BIC model selection method.}
    \item{predsaic}{Mean squared prediction error risk in test data set, produced by SAIC model averaging method.}
    \item{predsbic}{Mean squared prediction error risk in test data set, produced by SBIC model averaging method.}
    \item{predcv}{Mean squared prediction error risk in test data set, produced by CVMA method.}
}
\description{
Summarize the estimate of weights for averaging across all candidate models for PLFAMs, using multi-fold cross-validation criterion,
     and the corresponding mean squared prediction error risk. Additionally, the results of AIC, BIC, SAIC and SBIC are delivered simultaneously.
}
\examples{
# Generate simulated data
simdata = data_gen(R = 0.7, K = 1, n = 50, M0 = 20, typ = 1, design = 3)
dat1 = simdata[[1]]
scalars = dat1[,1:20]
fd = dat1[,21:120]
Y = dat1[,122]
tps = seq(0, 1, length.out = 100)

# Estimation
est_res = cvmaPLFAM(Y=Y, scalars = scalars, functional = fd, tt = tps,
       nump = 2, numfpcs = 3, nbasis = 50, nfolds = 5, ratio.train = 0.8)
# Weights estimated by CVMA method
est_res$wcv
# Prediction error risk on test data set
est_res$predcv

}
