% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_plot.R
\name{cv_plot}
\alias{cv_plot}
\title{Wrapper for plotting common plots using ggplot2}
\usage{
cv_plot(x, type)
}
\arguments{
\item{x}{Object returned by cvms::\link{cross_validate}() (tbl)}

\item{type}{Type of plot.

 \subsection{Gaussian}{

 'RMSE' - boxplot

 'r2' - boxplot

 'IC' - boxplot

 'coefficients' - boxplot
 }

 \subsection{Binomial}{

 "ROC" - ROC curve

 }}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Creates various plots based on
 the output of cvms::\link{cross_validate}()
}
\examples{
\donttest{
# Attach packages
library(cvms)
library(groupdata2) # fold()

# Load data (included in cvms)
data <- participant.scores

# Fold data
data <- fold(data, k = 4,
             cat_col = 'diagnosis',
             id_col = 'participant')

# Cross-validate a gaussian model
CVgauss <- cross_validate(data,
                          "score~diagnosis",
                          family='gaussian')

# Plot results for gaussian model
cv_plot(CVgauss, type = 'RMSE')
cv_plot(CVgauss, type = 'r2')
cv_plot(CVgauss, type = 'IC')
cv_plot(CVgauss, type = 'coefficients')

# Cross-validate a binomial model
CVbinom <- cross_validate(data,
                          "diagnosis~score",
                          family='binomial')

# Plot results for binomial model
cv_plot(CVbinom, type = 'ROC')
}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
