% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cobra_validate.r
\name{get_validation}
\alias{get_validation}
\title{Select Validation Set for a Matrix}
\usage{
get_validation(p, n, fraction = 0.1, seed = 12345)
}
\arguments{
\item{p}{Number of rows}

\item{n}{Number of columns}

\item{fraction}{Fraction of entries for hold out}

\item{seed}{Seed for random number generator}
}
\description{
\code{get_validation} selects a random sample of matrix indices for regularization parameter selection.
}
\examples{
n <- 5
p <- 4
fraction <- 0.1
Theta <- get_validation(p,n,fraction)

M <- matrix(rnorm(n*p),p,n)
YT <- t(M)
YT[Theta$ThetaV] <- NA
Y <- t(YT)
Theta
}

